FORMAT: 1A

# Responses API
In this API example we will discuss what information a response can bear and
how to define multiple responses. Technically a response is represented by a
payload that is sent back in response to a request.

## API Blueprint
+ [Previous: Grouping Resources](04.%20Grouping%20Resources.md)
+ [This: Raw API Blueprint](https://raw.github.com/apiaryio/api-blueprint/master/examples/05.%20Responses.md)
+ [Next: Requests](06.%20Requests.md)

# Group Messages
Group of all messages-related resources.

## My Message [/message]

### Retrieve a Message [GET]
This action has **two** responses defined: One returning plain text and the
other a JSON representation of our resource. Both have the same HTTP status
code. Also both responses bear additional information in the form of a custom
HTTP header. Note that both responses have set the `Content-Type` HTTP header
just by specifying `(text/plain)` or `(application/json)` in their respective
signatures.

+ Response 200 (text/plain)

    + Headers

            X-My-Message-Header: 42

    + Body

            Hello World!

+ Response 200 (application/json)

    + Headers

            X-My-Message-Header: 42

    + Body

            { "message": "Hello World!" }

### Update a Message [PUT]

+ Request (text/plain)

        All your base are belong to us.

+ Response 204
